@extends('layouts.app')
@section('content')
<div class="content-wrapper">
	<div class="content py-3">
		<div class="container-fluid">
			<div class="card border-0 shadow-custom mb-0">
				<div class="card-header border-grey">
					<h3 class="card-title">
						{{ __('member.update_title') }}
					</h3>
				</div>
				<form method="post" action="{{ route('member.update', $member->id) }}" enctype="multipart/form-data">
					{{ csrf_field() }}
					<input name="_method" type="hidden" value="PATCH">
					<div class="card-body">
						@if(!empty($member->profile_picture))
						<div class="row mb-3">
							<div class="col-lg-12">
								<div class="user-image elevation-3" id="edit-image"
									style="background-image: url(' {{ asset('images/profile/'.$member->profile_picture) }} ');">
								</div>
							</div>
						</div>
						@endif
						<div class="row">
							<div class="col-lg-12">
								<div class="user-image elevation-3 d-none" id="image-preview"></div>
							</div>
						</div>
						<div class="row">
							<div class="col-lg-6">
								<div class="form-group">
									<label for="reg_no">{{ __('member.reg_no') }}</label>
									<input type="text" value="{{ $member->reg_no }}" class="form-control" name="reg_no"
										id="reg_no" readonly>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="name" class="required">{{ __('member.name') }}</label>
									<input type="text" value="{{ $member->name }}"
										class="form-control @error('name') is-invalid @enderror" name="name" id="name">
									@error('name')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="gender">{{ __('member.gender') }}</label>
									<select class="form-control" name="gender" id="gender">
										<option value="male" @if ($member->gender == 'male') selected @endif>
											Male
										</option>
										<option value="female" @if ($member->gender == 'female') selected @endif>
											Female
										</option>
									</select>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="age">{{ __('member.age') }}</label>
									<input value="{{ $member->age }}" type="text" class="form-control" name="age"
										id="age">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="phone" class="required">{{ __('member.phone') }}</label>
									<input value="{{ $member->phone }}" type="text"
										class="form-control @error('phone') is-invalid @enderror" name="phone"
										id="phone">
									@error('phone')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="address">{{ __('member.address') }}</label>
									<input value="{{ $member->address }}" type="text" class="form-control"
										name="address" id="address">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="height">{{ __('member.height') }}</label>
									<input value="{{ $member->height }}" type="text" class="form-control" name="height"
										id="height">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="weight">{{ __('member.weight') }}</label>
									<input value="{{ $member->weight }}" type="text" class="form-control" name="weight"
										id="weight">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="interested_area">{{ __('member.interested_area') }}</label>
									<input value="{{ $member->interested_area }}" name="interested_area" type="text"
										class="form-control" id="interested_area">
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="profile_picture">{{ __('member.profile_picture') }}</label>
									<div class="input-group">
										<div class="custom-file">
											<input name="profile_picture" type="file"
												class="custom-file-input @error('profile_picture') is-invalid @enderror"
												id="profile_picture">
											<label class="custom-file-label" for="profile_picture">{{
												__('member.choose_file') }}</label>
											@error('profile_picture')
											<span class="d-block invalid-feedback">{{ $message }}</span>
											@enderror
										</div>
									</div>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="status">{{ __('member.status') }}</label>
									<select class="form-control" name="status" id="status">
										<option value="active" @if ($member->status == 'active') selected @endif>
											Active
										</option>
										<option value="disabled" @if ($member->status == 'disabled') selected @endif>
											Disabled
										</option>
									</select>
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-membership-type" class="required">{{ __('member.membership')
										}}</label>
									<select
										class="form-control select-membership-type @error('type') is-invalid @enderror"
										name="type" id="js-membership-type">
										@foreach($types as $type)
										<option value="{{ $type->id }}" data-duration="{{ $type->duration }}"
											@if(isset($member->latest_membership->membership_type->id) &&
											$member->latest_membership->membership_type->id == $type->id) selected
											@endif>
											{{ $type->name }}
										</option>
										@endforeach
									</select>
									@error('type')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
								<input type="hidden" name="membership_id" value="{{ $member->latest_membership->id }}">
							</div>

							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-valid-from" class="required">{{ __('member.membership_valid_from')
										}}</label>
									<div class="input-group date" id="date-valid-from" data-target-input="nearest">
										<input type="text"
											class="form-control datetimepicker-input @error('valid_from') is-invalid @enderror"
											value="{{ isset($member->latest_membership->valid_from) ? $member->latest_membership->valid_from : '' }}"
											name="valid_from" data-target="#date-valid-from" id="js-valid-from" />
										<div class="input-group-append" data-target="#date-valid-from"
											data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fa fa-calendar"></i></div>
										</div>
									</div>
									@error('valid_from')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>
							<div class="col-lg-6">
								<div class="form-group">
									<label for="js-valid-to" class="required">{{ __('member.to') }}</label>
									<div class="input-group date" id="date-valid-to" data-target-input="nearest">
										<input type="text"
											class="form-control datetimepicker-input @error('valid_to') is-invalid @enderror"
											value="{{ isset($member->latest_membership->valid_to) ? $member->latest_membership->valid_to : '' }}"
											name="valid_to" data-target="#date-valid-to" id="js-valid-to" />
										<div class="input-group-append" data-target="#date-valid-to"
											data-toggle="datetimepicker">
											<div class="input-group-text"><i class="fa fa-calendar"></i></div>
										</div>
									</div>
									@error('valid_to')
									<span class="d-block invalid-feedback">{{ $message }}</span>
									@enderror
								</div>
							</div>

							<div class="col-lg-12">
								@if(!empty($member->memberships) && count($member->memberships) != 0)
								<div clas="row">
									<div clas="col-12">
										<p class="lead">{{ __('member.membership_history') }}</p>
										<div class="table-responsive">
											<table class="table custom-table-bordered table-hover">
												<thead>
													<tr>
														<th class="nowrap">{{ __('member.th_membership_type') }}</th>
														<th>{{ __('member.th_amount') }}</th>
														<th class="nowrap">{{ __('member.th_valid_from') }}</th>
														<th class="nowrap">{{ __('member.th_valid_to') }}</th>
														<th class="nowrap">{{ __('member.th_created_at') }}</th>
														<th class="nowrap">{{ __('member.th_action') }}</th>
													</tr>
												</thead>
												<tbody>
													@foreach($member->memberships as $membership)
													<tr>
														<td class="nowrap align-middle">{{
															$membership->membership_type->name }}</td>
														<td class="nowrap align-middle">{{
															format_amount($membership->membership_type->amount) }}</td>
														<td class="nowrap align-middle">{{
															format_date($membership->valid_from) }}</td>
														<td class="nowrap align-middle">{{
															format_date($membership->valid_to) }}</td>
														<td class="nowrap align-middle">{{
															format_date($membership->created_at) }}</td>
														<td class="nowrap align-middle">
															<a href="{{ route('invoice.show', $membership->id) }}"
																type="button" class="btn btn-sm btn-warning mr-2">
																<i class="fa fa-print"></i>
															</a>
														</td>
													</tr>
													@endforeach
												</tbody>
											</table>
										</div>
									</div>
								</div>
								@endif
							</div>
							<div class="col-lg-6">
								<button type="submit" class="btn btn-primary mt-1">{{ __('member.update_member')
									}}</button>
							</div>
						</div>
					</div>
				</form>
			</div>
		</div>
	</div>
</div>
@endsection
@section('js-script')
<!-- PAGE SPECIFIC CUSTOM SCRIPT -->
<script>
	$(function () {
		"use strict";
		// INITIALIZE SELECT2 ELEMENT
		$('.select-membership-type').select2({
			theme: 'bootstrap4'
		})

		// INITIALIZE THE DATE PICKER
		$('#date-valid-from').datetimepicker({
			format: 'YYYY-MM-DD'
		});

		$('#date-valid-to').datetimepicker({
			format: 'YYYY-MM-DD',
			readonly: true
		});

		// CALCULATE THE MEMBERSHIP VALID TO DATE
		$('#js-membership-type, #js-valid-from').on('change input', function () {
			var membershipId = parseInt($('#js-membership-type option:selected').val());
			var membershipDuration = parseInt($('#js-membership-type option:selected').data('duration'));
			var validFromDate = moment($('#js-valid-from').val(), 'YYYY-MM-DD');

			if (validFromDate.isValid() && !isNaN(membershipDuration)) {
				var validToDate = validFromDate.clone().add(membershipDuration, 'days');
				$('#js-valid-to').val(validToDate.format('YYYY-MM-DD'));
			}
		});

		// EVENT LISTENER TO PREVIEW PROFILE IMAGE
		$('.custom-file-input').on('change', function () {
			if (this.files && this.files[0]) {

				var file = this.files[0];

				var reader = new FileReader();

				reader.onload = function (e) {
					$('#image-preview').css('background-image', 'url(' + e.target.result + ')');
					$('#image-preview').removeClass('d-none');
					$('#edit-image').addClass('d-none');
					$('#image-preview').addClass('mb-3');
				};

				reader.readAsDataURL(file);

			} else {
				$('#image-preview').addClass('d-none');
				$('#image-preview').removeClass('mb-3');
			}
		});
	});
</script>
@endsection